#define    VOLUMENONE          0x00
#define    VOLUMEUP            0x01
#define    VOLUMEDOWN          0x02
#define    VOLUMEMUTE          0x04

#define    KEYPLAYPAUSE        0x08
#define    KEYNEXT             0x10
#define    KEYPREVIOUS         0x20
#define    KEYSTOP             0x40
#define    KEYMEDIAPLAY        0x80


#define    SPKALTSET0          0x00
#define    SPKALTSET1          0x01


typedef struct
   { BYTE Busy;                                  // Speak Status
     BYTE Button;                                // Volume Up/Down , Mute
     signed char Vol_Tmp;                        // Temp Volume 
     signed char Vol_Cur;                        // Volume Current
     signed char Vol_Max;                        // Volume Max
     signed char Vol_Min;                        // Volume Min
     signed char Silente;                        // Volume Silente
     signed char LCurVol;                        // Left Current Volume
     signed char RCurVol;                        // Right Current Volume
     signed char Mic_Max;                        // Mic Volume Max
     signed char Mic_Cur;                        // Volume Current
     signed char Mix_Max;                        // Mix Volume Max
     signed char Mix_Cur;                        // Mix Current
     signed char Bas_Cur;                        // Bass Current
     signed char Bas_Max;                        // Bass Max
     signed char Bas_Min;                        // Bass Min
     signed char Trb_Cur;                        // Treble Current
     signed char Trb_Max;                        // Treble Max
     signed char Trb_Min;                        // Treble Min
     BYTE Vol_Mute;                              // Mute Status( 1 for Mute )
     BYTE Mic_Mute;                              // Mute Status( 1 for Mute )
     BYTE Mix_Mute;                              // Mute Status( 1 for Mute )
     BYTE Tmp;                                   // For Temp Buffer
     BYTE Cnt;
     BYTE IDS;                                   // ID Selector
     BYTE CS;                                    // Channel Selector
     BYTE Channel;                               // Volume Channel
     BYTE IdleRate;                              // For HID
     union WTYPE IdleRateCnt;                    // 
     BYTE HfCon;                                 // 
     BYTE PfTl;                                  // 
     BYTE HfSeed;                                // 
     BYTE HitErr;                                // 
   } SPK;                                        // USB Speaker


#define    SPK_X_CHANNEL       0xFF
#define    SPK_M_CHANNEL       0x00
#define    SPK_L_CHANNEL       0x01
#define    SPK_R_CHANNEL       0x02

#define    SPK_CS_UNDEFINED    0x00
#define    SPK_CS_MUTE         0x01
#define    SPK_CS_VOLUME       0x02
#define    SPK_CS_BASS         0x03
#define    SPK_CS_TREBLE       0x05
#define    SPK_CS_FEQ          0x80              // Not define in Audio Spec.

#define    ID_SU               0x05              // Select Unit
#define    ID_SPK_FU           0x06              // Feature Unit With Gain Control
#define    ID_MIC_FU           0x07              // Feature Unit With Gain Control
#define    ID_MIX_FU           0x08              // Feature Unit With Gain Control
#define    ID_MIX              0x09              // Mixer Unit